using System;
using System.ComponentModel.Composition;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VIMT.VirtualMeetingRoom.Messages;
using VIMT.VirtualMeetingRoom.Processors;

namespace VIMT.VirtualMeetingRoom.MessageHandler
{
	[Export(typeof(IMessageHandler))]
	[ExportMetadata("MessageType", MessageRegistry.VIMTVyoptaSMScheduleMeetingRequest)]
	/// <summary>
	/// VIMT Enterprise Component for VIMT.VirtualMeetingRoom,ScheduleMeeting method, MessageHandler.
	/// Code Generated by IMS on: 4/12/2016 6:51:29 PM
	/// Version: 2016.04.08
	/// </summary>
	/// <param name=none></param>
	/// <returns>none</returns>
	public class VIMTVyoptaSMScheduleMeetingMessageHandler : RequestResponseHandler
	{
		public override IMessageBase HandleRequestResponse(object message)
		{
			try
			{
				LogMessageReceipt(message);
				var processor = new ScheduleMeetingProcessor();
				return processor.Execute((VIMTVyoptaSMScheduleMeetingRequest)message);
			}
			catch (Exception ex)
			{
				VIMTVyoptaSMScheduleMeetingRequest msg = (VIMTVyoptaSMScheduleMeetingRequest)message;
				LogHelper.LogError(msg.OrganizationName, msg.UserId, "ScheduleMeetingMessageHandler.HandleRequestResponse", ex);
				throw new Exception(string.Format("VIMTVyoptaSMScheduleMeetingMessageHandler Error: {0}", ex.Message), ex);
			}
		}
	}
}
